/*
 * Decompiled with CFR 0.152.
 */
package br.com.backforest.forestmonitor.service;

import br.com.backforest.forestmonitor.dto.LeituraRecordDTO;
import br.com.backforest.forestmonitor.model.Dispositivo;
import br.com.backforest.forestmonitor.model.Leitura;
import br.com.backforest.forestmonitor.repository.DispositivoRepository;
import br.com.backforest.forestmonitor.repository.LeituraRepository;
import br.com.backforest.forestmonitor.service.EmailService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MonitoramentoService {
    private final DispositivoRepository dispositivoRepository;
    private final LeituraRepository leituraRepository;
    private final EmailService emailService;

    public MonitoramentoService(DispositivoRepository dispositivoRepository, LeituraRepository leituraRepository, EmailService emailService) {
        this.dispositivoRepository = dispositivoRepository;
        this.leituraRepository = leituraRepository;
        this.emailService = emailService;
    }

    @Transactional
    public boolean registrarLeitura(LeituraRecordDTO dto) {
        Dispositivo dispositivo = this.dispositivoRepository.findByMacAddress(dto.mac()).orElseGet(() -> this.criarNovoDispositivo(dto.mac()));
        if (this.isLeituraDuplicada(dispositivo, dto.msgId())) {
            System.out.println("\u267b\ufe0f Leitura duplicada ou repetida em < 20min. Ignorando: MsgID " + dto.msgId());
            return false;
        }
        Leitura leitura = new Leitura();
        leitura.setMsgId(dto.msgId());
        leitura.setTemperaturaDht(dto.temperaturaDht());
        leitura.setUmidadeDht(dto.umidadeDht());
        leitura.setTemperaturaBmp(dto.temperaturaBmp());
        leitura.setPressaoBmp(dto.pressaoBmp());
        leitura.setMq135(dto.mq135());
        leitura.setClassificacao(dto.classificacao());
        leitura.setCodigoDetec(dto.codigoDetec());
        leitura.setDispositivo(dispositivo);
        this.leituraRepository.save((Object)leitura);
        System.out.println("\u2705 Leitura salva com sucesso: MsgID " + dto.msgId());
        if (dto.codigoDetec() != 0) {
            System.out.println("\ud83d\udea8 ALERTA DETECTADO! Iniciando envio de e-mail...");
            this.emailService.enviarAlertaPerigo(dispositivo.getMacAddress(), dto.classificacao(), dispositivo.getLatitude(), dispositivo.getLongitude());
        }
        return true;
    }

    private boolean isLeituraDuplicada(Dispositivo dispositivo, Integer msgId) {
        LocalDateTime agora;
        LocalDateTime dataExistente;
        long minutosPassados;
        Optional ultimaLeitura = this.leituraRepository.findTopByDispositivoAndMsgIdOrderByDataHoraDesc(dispositivo, msgId);
        return ultimaLeitura.isPresent() && (minutosPassados = ChronoUnit.MINUTES.between(dataExistente = ((Leitura)ultimaLeitura.get()).getDataHora(), agora = LocalDateTime.now())) < 20L;
    }

    private Dispositivo criarNovoDispositivo(String mac) {
        Dispositivo novo = new Dispositivo();
        novo.setMacAddress(mac);
        novo.setDescricao("Novo Sensor Detectado");
        return (Dispositivo)this.dispositivoRepository.save((Object)novo);
    }

    public List<Leitura> listarLeiturasPorDispositivo(Long idDispositivo) {
        return this.leituraRepository.findByDispositivoId(idDispositivo);
    }

    public List<Dispositivo> listarTodosDispositivos() {
        return this.dispositivoRepository.findAll();
    }

    public List<Leitura> listarLeituras(Long idDispositivo, LocalDate inicio, LocalDate fim) {
        if (inicio == null) {
            inicio = LocalDate.now();
        }
        if (fim == null) {
            fim = LocalDate.now();
        }
        LocalDateTime dataInicio = inicio.atStartOfDay();
        LocalDateTime dataFim = fim.atTime(LocalTime.MAX);
        return this.leituraRepository.findByDispositivoIdAndDataHoraBetweenOrderByDataHoraDesc(idDispositivo, dataInicio, dataFim);
    }
}

