/*
 * Decompiled with CFR 0.152.
 */
package br.com.backforest.forestmonitor.service;

import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    private final JavaMailSender mailSender;

    public EmailService(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    @Async
    public void enviarAlertaPerigo(String mac, String tipoAlerta, Double lat, Double lon) {
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom("alerta@florestamonitoramento.adrielwippel.com");
            message.setTo("adriel.wippel@outlook.com");
            message.setSubject("\ud83d\udea8 ALERTA FLORESTA: " + tipoAlerta.toUpperCase());
            String corpo = String.format("\u26a0\ufe0f ALERTA DE SEGURAN\u00c7A DETECTADO \u26a0\ufe0f\n\nTipo de Ocorr\u00eancia: %s\nDispositivo Sensor: %s\n\nLocaliza\u00e7\u00e3o Estimada:\nLatitude: %s\nLongitude: %s\n\nAcesse o painel para mais detalhes:\nhttps://florestamonitoramento.adrielwippel.com\n", tipoAlerta, mac, lat != null ? lat : "N/A", lon != null ? lon : "N/A");
            message.setText(corpo);
            this.mailSender.send(message);
            System.out.println("\ud83d\udce7 E-mail de alerta enviado para adriel.wippel@outlook.com");
        }
        catch (Exception e) {
            System.err.println("\u274c Erro ao enviar e-mail: " + e.getMessage());
        }
    }
}

